import math
import sys
from itertools import combinations

def read_input():
    n, epsilon = sys.stdin.readline().split()
    n = int(n)
    epsilon = float(epsilon)
    points = []
    for _ in range(n):
        x, y = sys.stdin.readline().split()
        points.append((float(x), float(y)))
    return n, epsilon, points

def manhattan_distance(p1, p2):
    return abs(p1[0] - p2[0]) + abs(p1[1] - p2[1])

def compute_graph(points):
    edges = []
    n = len(points)
    for i in range(n):
        for j in range(i+1, n):
            dist = manhattan_distance(points[i], points[j])
            edges.append((dist, i+1, j+1))
    return edges

def kruskal(n, edges):
    parent = list(range(n+1))
    def find(x):
        while parent[x] != x:
            parent[x] = parent[parent[x]]
            x = parent[x]
        return x
    def union(a, b):
        pa, pb = find(a), find(b)
        if pa != pb:
            parent[pb] = pa
            return True
        return False

    edges.sort(key=lambda e: e[0])
    mst = []
    total_weight = 0
    for w, u, v in edges:
        if union(u, v):
            mst.append((u, v))
            total_weight += w
            if len(mst) == n-1:
                break
    return mst, total_weight

def check_epiphany(tree1, tree2, epsilon):
    pass

def main():
    n, epsilon, points = read_input()
    edges = compute_graph(points)

    Q = list(range(1, n+1))
    mst, weight = kruskal(n, edges)

    print(len(Q))
    print(" ".join(map(str, Q)))
    for u, v in mst:
        print(u, v)

if __name__ == "__main__":
    main()